#include <Liquid_Crystal.h>
#include <Temp.h>


LiquidCrystal myLCD(0x27, 16, 2);  // Δήλωση της διεύθυνσης της οθόνης LCD. Η Σύνδεση γίνεται στη θύρα I2C


Temp myTemp(9);     // Δήλωση της θύρας του θερμομέτρου

void setup() {
    myLCD.begin();   //Έναρξη LCD
    myTemp.begin();  //Έναρξη θερμομέτρου
}

void loop() {
    myLCD.Text("Temp=", 0, 0);                           // Εμφάνιση κειμένου στην οθόνη LCD από τη στήλη 1 και γραμμή 1
    float temperature = myTemp.readTemperature();        // Δήλωση νέας μεταβλητής temperature και ανάγνωση θερμοκρασίας
    myLCD.Text(String(temperature,2).c_str(), 5, 0);     // Εμφάνιση θερμοκρασίας με 2 δεκαδικά ψηφία στην LCD από τη στήλη 6 και τη γραμμή 1
    delay(500);                                         //καθυστέρηση 0.5s
}
